/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.assertions.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.assertj.assertions.generator.AssertionGenerator;
import org.assertj.assertions.generator.AssertionsEntryPointGenerator;
import org.assertj.assertions.generator.AssertionsEntryPointType;
import org.assertj.assertions.generator.DefaultTemplateRegistryProducer;
import org.assertj.assertions.generator.Template;
import org.assertj.assertions.generator.TemplateRegistry;
import org.assertj.assertions.generator.description.ClassDescription;
import org.assertj.assertions.generator.description.DataDescription;
import org.assertj.assertions.generator.description.FieldDescription;
import org.assertj.assertions.generator.description.GetterDescription;
import org.assertj.assertions.generator.description.TypeName;

public class BaseAssertionGenerator
implements AssertionGenerator,
AssertionsEntryPointGenerator {
    static final String ABSTRACT_ASSERT_CLASS_PREFIX = "Abstract";
    static final String ASSERT_CLASS_SUFFIX = "Assert";
    static final String ASSERT_CLASS_FILE_SUFFIX = "Assert.java";
    static final String TEMPLATES_DIR = "templates" + File.separator;
    private static final String IMPORT_LINE = "import %s;%s";
    private static final String PREDICATE = "${predicate}";
    private static final String PREDICATE_NEG = "${neg_predicate}";
    private static final String PREDICATE_FOR_JAVADOC = "${predicate_for_javadoc}";
    private static final String NEGATIVE_PREDICATE_FOR_JAVADOC = "${negative_predicate_for_javadoc}";
    private static final String PREDICATE_FOR_FOR_ERROR_MESSAGE_PART1 = "${predicate_for_error_message_part1}";
    private static final String PREDICATE_FOR_FOR_ERROR_MESSAGE_PART2 = "${predicate_for_error_message_part2}";
    private static final String NEGATIVE_PREDICATE_FOR_FOR_ERROR_MESSAGE_PART1 = "${negative_predicate_for_error_message_part1}";
    private static final String NEGATIVE_PREDICATE_FOR_FOR_ERROR_MESSAGE_PART2 = "${negative_predicate_for_error_message_part2}";
    private static final String PROPERTY_WITH_UPPERCASE_FIRST_CHAR = "${Property}";
    private static final String PROPERTY_GETTER_CALL = "${getter}";
    private static final String PROPERTY_WITH_LOWERCASE_FIRST_CHAR = "${property}";
    private static final String PROPERTY_WITH_SAFE = "${property_safe}";
    private static final String PACKAGE = "${package}";
    private static final String PROPERTY_TYPE = "${propertyType}";
    private static final String PROPERTY_SIMPLE_TYPE = "${propertySimpleType}";
    private static final String PROPERTY_ASSERT_TYPE = "${propertyAssertType}";
    private static final String CLASS_TO_ASSERT = "${class_to_assert}";
    private static final String CUSTOM_ASSERTION_CLASS = "${custom_assertion_class}";
    private static final String SUPER_ASSERTION_CLASS = "${super_assertion_class}";
    private static final String SELF_TYPE = "${self_type}";
    private static final String MYSELF = "${myself}";
    private static final String ELEMENT_TYPE = "${elementType}";
    private static final String ELEMENT_ASSERT_TYPE = "${elementAssertType}";
    private static final String ALL_ASSERTIONS_ENTRY_POINTS = "${all_assertions_entry_points}";
    private static final String IMPORTS = "${imports}";
    private static final String THROWS = "${throws}";
    private static final String THROWS_JAVADOC = "${throws_javadoc}";
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private String targetBaseDirectory = ".";
    private TemplateRegistry templateRegistry;
    private static final Pattern CLASS_NAME_PATTERN = Pattern.compile("public class[\\s]+(?<CLASSNAME>\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)\\b");
    private static final Set<String> JAVA_KEYWORDS = new HashSet<String>();

    public BaseAssertionGenerator() throws IOException {
        this(TEMPLATES_DIR);
    }

    public BaseAssertionGenerator(String templatesDirectory) throws IOException {
        this.templateRegistry = DefaultTemplateRegistryProducer.create(templatesDirectory);
    }

    public void setDirectoryWhereAssertionFilesAreGenerated(String targetBaseDirectory) {
        this.targetBaseDirectory = targetBaseDirectory;
    }

    @Override
    public File generateCustomAssertionFor(ClassDescription classDescription) throws IOException {
        String assertionFileContent = this.generateCustomAssertionContentFor(classDescription);
        String targetDirectory = this.getDirectoryPathCorrespondingToPackage(classDescription.getPackageName());
        BaseAssertionGenerator.buildTargetDirectory(targetDirectory);
        return this.createFile(assertionFileContent, BaseAssertionGenerator.assertClassNameOf(classDescription) + ".java", targetDirectory);
    }

    @Override
    public File[] generateHierarchicalCustomAssertionFor(ClassDescription classDescription, Set<Class<?>> allClasses) throws IOException {
        String[] assertionFileContent = this.generateHierarchicalCustomAssertionContentFor(classDescription, allClasses);
        String targetDirectory = this.getDirectoryPathCorrespondingToPackage(classDescription.getPackageName());
        BaseAssertionGenerator.buildTargetDirectory(targetDirectory);
        File[] assertionClassesFile = new File[2];
        String concreteAssertClassFileName = BaseAssertionGenerator.assertClassNameOf(classDescription) + ".java";
        String abstractAssertClassFileName = BaseAssertionGenerator.abstractAssertClassNameOf(classDescription) + ".java";
        assertionClassesFile[0] = this.createFile(assertionFileContent[0], abstractAssertClassFileName, targetDirectory);
        assertionClassesFile[1] = this.createFile(assertionFileContent[1], concreteAssertClassFileName, targetDirectory);
        return assertionClassesFile;
    }

    @Override
    public String[] generateHierarchicalCustomAssertionContentFor(ClassDescription classDescription, Set<Class<?>> allClasses) {
        String abstractClassTemplateContent = this.templateRegistry.getTemplate(Template.Type.ABSTRACT_ASSERT_CLASS).getContent();
        StringBuilder abstractAssertClassContentBuilder = new StringBuilder(abstractClassTemplateContent);
        abstractAssertClassContentBuilder.append(this.generateAssertionsForDeclaredGettersOf(classDescription));
        abstractAssertClassContentBuilder.append(this.generateAssertionsForDeclaredPublicFieldsOf(classDescription));
        abstractAssertClassContentBuilder.append(LINE_SEPARATOR).append("}").append(LINE_SEPARATOR);
        String concreteAssertClassContent = this.templateRegistry.getTemplate(Template.Type.HIERARCHICAL_ASSERT_CLASS).getContent();
        StringBuilder concreteAssertClassContentBuilder = new StringBuilder(concreteAssertClassContent);
        String[] assertionClassesContent = new String[]{this.fillAssertClassTemplate(abstractAssertClassContentBuilder.toString(), classDescription, allClasses, false), this.fillAssertClassTemplate(concreteAssertClassContentBuilder.toString(), classDescription, null, true)};
        return assertionClassesContent;
    }

    private String fillAssertClassTemplate(String template, ClassDescription classDescription, Set<Class<?>> classesHierarchy, boolean concrete) {
        TypeName superAssertionClass;
        TreeSet<TypeName> assertjImports = new TreeSet<TypeName>();
        if (template.contains("Assertions.")) {
            assertjImports.add(new TypeName("org.assertj.core.api.Assertions"));
        }
        if (template.contains("Objects.")) {
            assertjImports.add(new TypeName("org.assertj.core.util.Objects"));
        }
        if (template.contains("Iterables.")) {
            assertjImports.add(new TypeName("org.assertj.core.internal.Iterables"));
        }
        if (classesHierarchy == null || !classesHierarchy.contains(classDescription.getSuperType())) {
            superAssertionClass = new TypeName("org.assertj.core.api.AbstractObjectAssert");
        } else {
            TypeName superTypeName = new TypeName(classDescription.getSuperType());
            superAssertionClass = new TypeName(BaseAssertionGenerator.abstractAssertClassNameOf(superTypeName), superTypeName.getPackageName());
        }
        assertjImports.add(superAssertionClass);
        String customAssertionClass = concrete ? BaseAssertionGenerator.assertClassNameOf(classDescription) : BaseAssertionGenerator.abstractAssertClassNameOf(classDescription);
        String selfType = concrete ? customAssertionClass : "S";
        String myself = concrete ? "this" : "myself";
        template = StringUtils.replace((String)template, (String)PACKAGE, (String)classDescription.getPackageName());
        template = StringUtils.replace((String)template, (String)CUSTOM_ASSERTION_CLASS, (String)customAssertionClass);
        template = StringUtils.replace((String)template, (String)SUPER_ASSERTION_CLASS, (String)superAssertionClass.getSimpleNameWithOuterClassNotSeparatedByDots());
        template = StringUtils.replace((String)template, (String)CLASS_TO_ASSERT, (String)classDescription.getClassNameWithOuterClass());
        template = StringUtils.replace((String)template, (String)SELF_TYPE, (String)selfType);
        template = StringUtils.replace((String)template, (String)MYSELF, (String)myself);
        template = StringUtils.replace((String)template, (String)IMPORTS, (String)BaseAssertionGenerator.listNeededImports(assertjImports, classDescription.getPackageName()));
        return template;
    }

    private String fillAssertClassTemplate(String template, ClassDescription classDescription) {
        return this.fillAssertClassTemplate(template, classDescription, null, true);
    }

    @Override
    public String generateCustomAssertionContentFor(ClassDescription classDescription) {
        String classTemplateContent = this.templateRegistry.getTemplate(Template.Type.ASSERT_CLASS).getContent();
        StringBuilder assertionFileContentBuilder = new StringBuilder(classTemplateContent);
        assertionFileContentBuilder.append(this.generateAssertionsForGettersOf(classDescription));
        assertionFileContentBuilder.append(this.generateAssertionsForPublicFieldsOf(classDescription));
        assertionFileContentBuilder.append(LINE_SEPARATOR).append("}").append(LINE_SEPARATOR);
        return this.fillAssertClassTemplate(assertionFileContentBuilder.toString(), classDescription);
    }

    @Override
    public String generateAssertionsEntryPointClassContentFor(Set<ClassDescription> classDescriptionSet, AssertionsEntryPointType assertionsEntryPointType, String entryPointClassPackage) {
        if (BaseAssertionGenerator.noClassDescriptionsGiven(classDescriptionSet)) {
            return "";
        }
        Template assertionEntryPointMethodTemplate = this.chooseAssertionEntryPointMethodTemplate(assertionsEntryPointType);
        Template assertionsEntryPointClassTemplate = this.chooseAssertionEntryPointClassTemplate(assertionsEntryPointType);
        return this.generateAssertionsEntryPointClassContent(classDescriptionSet, assertionsEntryPointClassTemplate, assertionEntryPointMethodTemplate, entryPointClassPackage);
    }

    private Template chooseAssertionEntryPointMethodTemplate(AssertionsEntryPointType assertionsEntryPointType) {
        switch (assertionsEntryPointType) {
            case SOFT: 
            case JUNIT_SOFT: 
            case AUTO_CLOSEABLE_SOFT: {
                return this.templateRegistry.getTemplate(Template.Type.SOFT_ENTRY_POINT_METHOD_ASSERTION);
            }
            case BDD: {
                return this.templateRegistry.getTemplate(Template.Type.BDD_ENTRY_POINT_METHOD_ASSERTION);
            }
            case BDD_SOFT: 
            case JUNIT_BDD_SOFT: 
            case AUTO_CLOSEABLE_BDD_SOFT: {
                return this.templateRegistry.getTemplate(Template.Type.BDD_SOFT_ENTRY_POINT_METHOD_ASSERTION);
            }
        }
        return this.templateRegistry.getTemplate(Template.Type.ASSERTION_ENTRY_POINT);
    }

    private Template chooseAssertionEntryPointClassTemplate(AssertionsEntryPointType assertionsEntryPointType) {
        switch (assertionsEntryPointType) {
            case SOFT: {
                return this.templateRegistry.getTemplate(Template.Type.SOFT_ASSERTIONS_ENTRY_POINT_CLASS);
            }
            case JUNIT_SOFT: {
                return this.templateRegistry.getTemplate(Template.Type.JUNIT_SOFT_ASSERTIONS_ENTRY_POINT_CLASS);
            }
            case AUTO_CLOSEABLE_SOFT: {
                return this.templateRegistry.getTemplate(Template.Type.AUTO_CLOSEABLE_SOFT_ASSERTIONS_ENTRY_POINT_CLASS);
            }
            case BDD: {
                return this.templateRegistry.getTemplate(Template.Type.BDD_ASSERTIONS_ENTRY_POINT_CLASS);
            }
            case BDD_SOFT: {
                return this.templateRegistry.getTemplate(Template.Type.BDD_SOFT_ASSERTIONS_ENTRY_POINT_CLASS);
            }
            case JUNIT_BDD_SOFT: {
                return this.templateRegistry.getTemplate(Template.Type.JUNIT_BDD_SOFT_ASSERTIONS_ENTRY_POINT_CLASS);
            }
            case AUTO_CLOSEABLE_BDD_SOFT: {
                return this.templateRegistry.getTemplate(Template.Type.AUTO_CLOSEABLE_BDD_SOFT_ASSERTIONS_ENTRY_POINT_CLASS);
            }
        }
        return this.templateRegistry.getTemplate(Template.Type.ASSERTIONS_ENTRY_POINT_CLASS);
    }

    @Override
    public File generateAssertionsEntryPointClassFor(Set<ClassDescription> classDescriptionSet, AssertionsEntryPointType assertionsEntryPointType, String entryPointClassPackage) throws IOException {
        if (BaseAssertionGenerator.noClassDescriptionsGiven(classDescriptionSet)) {
            return null;
        }
        String assertionsEntryPointFileContent = this.generateAssertionsEntryPointClassContentFor(classDescriptionSet, assertionsEntryPointType, entryPointClassPackage);
        String fileName = this.determineFileName(assertionsEntryPointFileContent, assertionsEntryPointType);
        return this.createAssertionsFileFor(classDescriptionSet, assertionsEntryPointFileContent, fileName, entryPointClassPackage);
    }

    private String determineFileName(String assertionsEntryPointFileContent, AssertionsEntryPointType assertionsEntryPointType) {
        Matcher classNameMatcher = CLASS_NAME_PATTERN.matcher(assertionsEntryPointFileContent);
        if (classNameMatcher.find()) {
            return classNameMatcher.group("CLASSNAME") + ".java";
        }
        return assertionsEntryPointType.getFileName();
    }

    private String generateAssertionsEntryPointClassContent(Set<ClassDescription> classDescriptionSet, Template entryPointAssertionsClassTemplate, Template entryPointAssertionMethodTemplate, String entryPointClassPackage) {
        String entryPointAssertionsClassContent = entryPointAssertionsClassTemplate.getContent();
        String classPackage = StringUtils.isEmpty((CharSequence)entryPointClassPackage) ? this.determineBestEntryPointsAssertionsClassPackage(classDescriptionSet) : entryPointClassPackage;
        entryPointAssertionsClassContent = StringUtils.replace((String)entryPointAssertionsClassContent, (String)PACKAGE, (String)classPackage);
        String allEntryPointsAssertionContent = this.generateAssertionEntryPointMethodsFor(classDescriptionSet, entryPointAssertionMethodTemplate);
        entryPointAssertionsClassContent = StringUtils.replace((String)entryPointAssertionsClassContent, (String)ALL_ASSERTIONS_ENTRY_POINTS, (String)allEntryPointsAssertionContent);
        return entryPointAssertionsClassContent;
    }

    private File createAssertionsFileFor(Set<ClassDescription> classDescriptionSet, String fileContent, String fileName, String assertionsClassPackage) throws IOException {
        String classPackage = StringUtils.isEmpty((CharSequence)assertionsClassPackage) ? this.determineBestEntryPointsAssertionsClassPackage(classDescriptionSet) : assertionsClassPackage;
        String assertionsDirectory = this.getDirectoryPathCorrespondingToPackage(classPackage);
        BaseAssertionGenerator.buildTargetDirectory(assertionsDirectory);
        return this.createFile(fileContent, fileName, assertionsDirectory);
    }

    private String generateAssertionEntryPointMethodsFor(Set<ClassDescription> classDescriptionSet, Template assertionEntryPointMethodTemplate) {
        TreeSet<ClassDescription> sortedClassDescriptionSet = new TreeSet<ClassDescription>(classDescriptionSet);
        StringBuilder allAssertThatsContentBuilder = new StringBuilder();
        String lineSeparator = System.getProperty("line.separator");
        for (ClassDescription classDescription : sortedClassDescriptionSet) {
            String assertionEntryPointMethodContent = assertionEntryPointMethodTemplate.getContent();
            assertionEntryPointMethodContent = StringUtils.replace((String)assertionEntryPointMethodContent, (String)CUSTOM_ASSERTION_CLASS, (String)BaseAssertionGenerator.fullyQualifiedAssertClassName(classDescription));
            assertionEntryPointMethodContent = StringUtils.replace((String)assertionEntryPointMethodContent, (String)CLASS_TO_ASSERT, (String)classDescription.getFullyQualifiedClassName());
            allAssertThatsContentBuilder.append(lineSeparator).append(assertionEntryPointMethodContent);
        }
        return allAssertThatsContentBuilder.toString();
    }

    private String determineBestEntryPointsAssertionsClassPackage(Set<ClassDescription> classDescriptionSet) {
        TreeSet<String> packages = new TreeSet<String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.length() - o2.length();
            }
        });
        for (ClassDescription classDescription : classDescriptionSet) {
            packages.add(classDescription.getPackageName());
        }
        return (String)packages.first();
    }

    private static String assertClassNameOf(ClassDescription classDescription) {
        return BaseAssertionGenerator.assertClassNameOf(classDescription.getTypeName());
    }

    private static String assertClassNameOf(TypeName type) {
        return type.getSimpleNameWithOuterClassNotSeparatedByDots() + ASSERT_CLASS_SUFFIX;
    }

    private static String abstractAssertClassNameOf(ClassDescription classDescription) {
        return BaseAssertionGenerator.abstractAssertClassNameOf(classDescription.getTypeName());
    }

    private static String abstractAssertClassNameOf(TypeName type) {
        return ABSTRACT_ASSERT_CLASS_PREFIX + BaseAssertionGenerator.assertClassNameOf(type);
    }

    private static String fullyQualifiedAssertClassName(ClassDescription classDescription) {
        return classDescription.getPackageName() + "." + classDescription.getClassNameWithOuterClassNotSeparatedByDots() + ASSERT_CLASS_SUFFIX;
    }

    private String getDirectoryPathCorrespondingToPackage(String packageName) {
        return this.targetBaseDirectory + File.separator + packageName.replace('.', File.separatorChar);
    }

    private static String listNeededImports(Set<TypeName> typesToImport, String classPackage) {
        StringBuilder importsBuilder = new StringBuilder();
        for (TypeName type : typesToImport) {
            if (type.isPrimitive() || type.belongsToJavaLangPackage() || type.getPackageName().equals(classPackage)) continue;
            importsBuilder.append(String.format(IMPORT_LINE, type, LINE_SEPARATOR));
        }
        return importsBuilder.toString();
    }

    protected String generateAssertionsForGettersOf(ClassDescription classDescription) {
        return this.generateAssertionsForGetters(classDescription.getGettersDescriptions(), classDescription);
    }

    protected String generateAssertionsForDeclaredGettersOf(ClassDescription classDescription) {
        return this.generateAssertionsForGetters(classDescription.getDeclaredGettersDescriptions(), classDescription);
    }

    protected String generateAssertionsForGetters(Set<GetterDescription> getters, ClassDescription classDescription) {
        StringBuilder assertionsForGetters = new StringBuilder();
        for (GetterDescription getter : getters) {
            String assertionContent = this.assertionContentForProperty(getter, classDescription);
            assertionsForGetters.append(assertionContent).append(LINE_SEPARATOR);
        }
        return assertionsForGetters.toString();
    }

    protected String generateAssertionsForPublicFieldsOf(ClassDescription classDescription) {
        return this.generateAssertionsForPublicFields(classDescription.getFieldsDescriptions(), classDescription);
    }

    protected String generateAssertionsForDeclaredPublicFieldsOf(ClassDescription classDescription) {
        return this.generateAssertionsForPublicFields(classDescription.getDeclaredFieldsDescriptions(), classDescription);
    }

    protected String generateAssertionsForPublicFields(Set<FieldDescription> fields, ClassDescription classDescription) {
        StringBuilder assertionsForPublicFields = new StringBuilder();
        for (FieldDescription field : fields) {
            String assertionContent = this.assertionContentForField(field, classDescription);
            assertionsForPublicFields.append(assertionContent).append(LINE_SEPARATOR);
        }
        return assertionsForPublicFields.toString();
    }

    private String assertionContentForField(FieldDescription field, ClassDescription classDescription) {
        String fieldName = field.getName();
        String fieldNameCap = StringUtils.capitalize((String)field.getName());
        if (classDescription.getGettersDescriptions().contains(new GetterDescription(fieldName, "get" + fieldNameCap, field.getTypeDescription(), Collections.emptyList()))) {
            return "";
        }
        String assertionContent = this.baseAssertionContentFor(field, classDescription);
        assertionContent = assertionContent.replace("${getter}()", PROPERTY_WITH_LOWERCASE_FIRST_CHAR);
        assertionContent = StringUtils.remove((String)assertionContent, (String)THROWS);
        assertionContent = StringUtils.remove((String)assertionContent, (String)THROWS_JAVADOC);
        if (field.isPredicate()) {
            assertionContent = assertionContent.replace("actual.${predicate}()", "actual." + field.getOriginalMember());
            assertionContent = assertionContent.replace(PREDICATE_FOR_JAVADOC, field.getPredicateForJavadoc());
            assertionContent = assertionContent.replace(NEGATIVE_PREDICATE_FOR_JAVADOC, field.getNegativePredicateForJavadoc());
            assertionContent = assertionContent.replace(PREDICATE_FOR_FOR_ERROR_MESSAGE_PART1, field.getPredicateForErrorMessagePart1());
            assertionContent = assertionContent.replace(PREDICATE_FOR_FOR_ERROR_MESSAGE_PART2, field.getPredicateForErrorMessagePart2());
            assertionContent = assertionContent.replace(NEGATIVE_PREDICATE_FOR_FOR_ERROR_MESSAGE_PART1, field.getNegativePredicateForErrorMessagePart1());
            assertionContent = assertionContent.replace(NEGATIVE_PREDICATE_FOR_FOR_ERROR_MESSAGE_PART2, field.getNegativePredicateForErrorMessagePart2());
            assertionContent = StringUtils.replace((String)assertionContent, (String)PREDICATE, (String)field.getPredicate());
            assertionContent = StringUtils.replace((String)assertionContent, (String)PREDICATE_NEG, (String)field.getNegativePredicate());
        }
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_WITH_UPPERCASE_FIRST_CHAR, (String)fieldNameCap);
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_SIMPLE_TYPE, (String)field.getTypeName());
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_ASSERT_TYPE, (String)field.getAssertTypeName(classDescription.getPackageName()));
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_TYPE, (String)field.getFullyQualifiedTypeNameIfNeeded(classDescription.getPackageName()));
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_WITH_LOWERCASE_FIRST_CHAR, (String)fieldName);
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_WITH_SAFE, (String)fieldName);
        return assertionContent;
    }

    private static String getSafeProperty(String unsafe) {
        return JAVA_KEYWORDS.contains(unsafe) ? "expected" + StringUtils.capitalize((String)unsafe) : unsafe;
    }

    private String assertionContentForProperty(GetterDescription getter, ClassDescription classDescription) {
        String assertionContent = this.baseAssertionContentFor(getter, classDescription);
        assertionContent = this.declareExceptions(getter, assertionContent, classDescription);
        String propertyName = getter.getPropertyName();
        if (getter.isPredicate()) {
            assertionContent = assertionContent.replace(PREDICATE_FOR_JAVADOC, getter.getPredicateForJavadoc());
            assertionContent = assertionContent.replace(NEGATIVE_PREDICATE_FOR_JAVADOC, getter.getNegativePredicateForJavadoc());
            assertionContent = assertionContent.replace(PREDICATE_FOR_FOR_ERROR_MESSAGE_PART1, getter.getPredicateForErrorMessagePart1());
            assertionContent = assertionContent.replace(PREDICATE_FOR_FOR_ERROR_MESSAGE_PART2, getter.getPredicateForErrorMessagePart2());
            assertionContent = assertionContent.replace(NEGATIVE_PREDICATE_FOR_FOR_ERROR_MESSAGE_PART1, getter.getNegativePredicateForErrorMessagePart1());
            assertionContent = assertionContent.replace(NEGATIVE_PREDICATE_FOR_FOR_ERROR_MESSAGE_PART2, getter.getNegativePredicateForErrorMessagePart2());
            assertionContent = StringUtils.replace((String)assertionContent, (String)PREDICATE, (String)getter.getOriginalMember());
            assertionContent = StringUtils.replace((String)assertionContent, (String)PREDICATE_NEG, (String)getter.getNegativePredicate());
        }
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_GETTER_CALL, (String)getter.getOriginalMember());
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_WITH_UPPERCASE_FIRST_CHAR, (String)StringUtils.capitalize((String)propertyName));
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_SIMPLE_TYPE, (String)getter.getTypeName());
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_ASSERT_TYPE, (String)getter.getAssertTypeName(classDescription.getPackageName()));
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_TYPE, (String)getter.getFullyQualifiedTypeNameIfNeeded(classDescription.getPackageName()));
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_WITH_LOWERCASE_FIRST_CHAR, (String)propertyName);
        assertionContent = StringUtils.replace((String)assertionContent, (String)PROPERTY_WITH_SAFE, (String)BaseAssertionGenerator.getSafeProperty(propertyName));
        return assertionContent;
    }

    private String baseAssertionContentFor(DataDescription fieldOrProperty, ClassDescription classDescription) {
        String assertionContent = this.templateRegistry.getTemplate(Template.Type.HAS).getContent();
        if (fieldOrProperty.isPredicate()) {
            Template.Type type = this.determinePredicateType(fieldOrProperty, classDescription);
            assertionContent = this.templateRegistry.getTemplate(type).getContent();
        } else if (fieldOrProperty.isIterableType()) {
            assertionContent = StringUtils.replace((String)this.templateRegistry.getTemplate(Template.Type.HAS_FOR_ITERABLE).getContent(), (String)ELEMENT_TYPE, (String)fieldOrProperty.getElementTypeName(classDescription.getPackageName()));
            assertionContent = StringUtils.replace((String)assertionContent, (String)ELEMENT_ASSERT_TYPE, (String)fieldOrProperty.getElementAssertTypeName(classDescription.getPackageName()));
        } else if (fieldOrProperty.isArrayType()) {
            assertionContent = StringUtils.replace((String)this.templateRegistry.getTemplate(Template.Type.HAS_FOR_ARRAY).getContent(), (String)ELEMENT_TYPE, (String)fieldOrProperty.getElementTypeName(classDescription.getPackageName()));
            assertionContent = StringUtils.replace((String)assertionContent, (String)ELEMENT_ASSERT_TYPE, (String)fieldOrProperty.getElementAssertTypeName(classDescription.getPackageName()));
        } else if (fieldOrProperty.isRealNumberType()) {
            Template.Type type = fieldOrProperty.isPrimitiveWrapperType() ? Template.Type.HAS_FOR_REAL_NUMBER_WRAPPER : Template.Type.HAS_FOR_REAL_NUMBER;
            assertionContent = this.templateRegistry.getTemplate(type).getContent();
        } else if (fieldOrProperty.isWholeNumberType()) {
            Template.Type type = fieldOrProperty.isPrimitiveWrapperType() ? Template.Type.HAS_FOR_WHOLE_NUMBER_WRAPPER : Template.Type.HAS_FOR_WHOLE_NUMBER;
            assertionContent = this.templateRegistry.getTemplate(type).getContent();
        } else if (fieldOrProperty.isCharType()) {
            Template.Type type = fieldOrProperty.isPrimitiveWrapperType() ? Template.Type.HAS_FOR_CHARACTER : Template.Type.HAS_FOR_CHAR;
            assertionContent = this.templateRegistry.getTemplate(type).getContent();
        } else if (fieldOrProperty.isPrimitiveType()) {
            Template.Type type = fieldOrProperty.isPrimitiveWrapperType() ? Template.Type.HAS_FOR_PRIMITIVE_WRAPPER : Template.Type.HAS_FOR_PRIMITIVE;
            assertionContent = this.templateRegistry.getTemplate(type).getContent();
        }
        return assertionContent;
    }

    private Template.Type determinePredicateType(DataDescription fieldOrProperty, ClassDescription classDescription) {
        if (this.hasAlreadyNegativePredicate(fieldOrProperty, classDescription)) {
            return fieldOrProperty.isPrimitiveWrapperType() ? Template.Type.IS_WRAPPER_WITHOUT_NEGATION : Template.Type.IS_WITHOUT_NEGATION;
        }
        return fieldOrProperty.isPrimitiveWrapperType() ? Template.Type.IS_WRAPPER : Template.Type.IS;
    }

    private boolean hasAlreadyNegativePredicate(DataDescription fieldOrProperty, ClassDescription classDescription) {
        for (GetterDescription getterDescription : classDescription.getGettersDescriptions()) {
            if (!getterDescription.getOriginalMember().equals(fieldOrProperty.getNegativePredicate())) continue;
            return true;
        }
        return false;
    }

    private String declareExceptions(GetterDescription getter, String assertionContent, ClassDescription classDescription) {
        StringBuilder throwsClause = new StringBuilder();
        StringBuilder throwsJavaDoc = new StringBuilder();
        boolean first = true;
        for (TypeName exception : getter.getExceptions()) {
            if (first) {
                throwsClause.append("throws ");
            } else {
                throwsClause.append(", ");
            }
            first = false;
            String exceptionName = exception.getFullyQualifiedTypeNameIfNeeded(classDescription.getPackageName());
            throwsClause.append(exceptionName);
            throwsJavaDoc.append(LINE_SEPARATOR).append("   * @throws ").append(exceptionName);
            throwsJavaDoc.append(" if actual.").append("${getter}() throws one.");
        }
        if (!getter.getExceptions().isEmpty()) {
            throwsClause.append(' ');
        }
        assertionContent = assertionContent.replace(THROWS_JAVADOC, throwsJavaDoc.toString());
        assertionContent = assertionContent.replace(THROWS, throwsClause.toString());
        return assertionContent;
    }

    private void fillFile(String customAssertionContent, File assertionJavaFile) throws IOException {
        try (FileWriter fileWriter = new FileWriter(assertionJavaFile);){
            fileWriter.write(customAssertionContent);
        }
    }

    private File createFile(String fileContent, String fileName, String targetDirectory) throws IOException {
        File file = new File(targetDirectory, fileName);
        file.createNewFile();
        this.fillFile(fileContent, file);
        return file;
    }

    private static boolean noClassDescriptionsGiven(Set<ClassDescription> classDescriptionSet) {
        return classDescriptionSet == null || classDescriptionSet.isEmpty();
    }

    private static void buildTargetDirectory(String targetDirectory) {
        new File(targetDirectory).mkdirs();
    }

    @Override
    public void register(Template template) {
        this.templateRegistry.register(template);
    }

    static {
        String[] keywords = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "protected", "private", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
        Collections.addAll(JAVA_KEYWORDS, keywords);
    }
}

