/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.assertions.generator.description;

import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import org.assertj.assertions.generator.description.FieldDescription;
import org.assertj.assertions.generator.description.GetterDescription;
import org.assertj.assertions.generator.description.TypeName;

public class ClassDescription
implements Comparable<ClassDescription> {
    private Set<GetterDescription> gettersDescriptions;
    private Set<FieldDescription> fieldsDescriptions;
    private Set<GetterDescription> declaredGettersDescriptions;
    private Set<FieldDescription> declaredFieldsDescriptions;
    private TypeName classTypeName;
    private Class<?> superType;

    public ClassDescription(TypeName typeName) {
        this.classTypeName = typeName;
        this.gettersDescriptions = new TreeSet<GetterDescription>();
        this.fieldsDescriptions = new TreeSet<FieldDescription>();
        this.declaredGettersDescriptions = new TreeSet<GetterDescription>();
        this.declaredFieldsDescriptions = new TreeSet<FieldDescription>();
    }

    public String getClassName() {
        return this.classTypeName.getSimpleName();
    }

    public String getFullyQualifiedClassName() {
        return this.classTypeName.getFullyQualifiedClassName();
    }

    public TypeName getTypeName() {
        return this.classTypeName;
    }

    public String getClassNameWithOuterClass() {
        return this.classTypeName.getSimpleNameWithOuterClass();
    }

    public String getClassNameWithOuterClassNotSeparatedByDots() {
        return this.classTypeName.getSimpleNameWithOuterClassNotSeparatedByDots();
    }

    public String getPackageName() {
        return this.classTypeName.getPackageName();
    }

    public Set<GetterDescription> getGettersDescriptions() {
        return this.gettersDescriptions;
    }

    public void addGetterDescriptions(Collection<GetterDescription> getterDescriptions) {
        this.gettersDescriptions.addAll(getterDescriptions);
    }

    public void addFieldDescriptions(Set<FieldDescription> fieldDescriptions) {
        this.fieldsDescriptions.addAll(fieldDescriptions);
    }

    public Set<FieldDescription> getFieldsDescriptions() {
        return this.fieldsDescriptions;
    }

    public Set<GetterDescription> getDeclaredGettersDescriptions() {
        return this.declaredGettersDescriptions;
    }

    public Set<FieldDescription> getDeclaredFieldsDescriptions() {
        return this.declaredFieldsDescriptions;
    }

    public void addDeclaredGetterDescriptions(Collection<GetterDescription> declaredGetterDescriptions) {
        this.declaredGettersDescriptions.addAll(declaredGetterDescriptions);
    }

    public void addDeclaredFieldDescriptions(Set<FieldDescription> declaredFieldDescriptions) {
        this.declaredFieldsDescriptions.addAll(declaredFieldDescriptions);
    }

    public String toString() {
        return "ClassDescription [classTypeName=" + this.classTypeName + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClassDescription)) {
            return false;
        }
        ClassDescription that = (ClassDescription)o;
        return !(this.classTypeName != null ? !this.classTypeName.equals(that.classTypeName) : that.classTypeName != null);
    }

    public int hashCode() {
        return this.classTypeName != null ? this.classTypeName.hashCode() : 0;
    }

    @Override
    public int compareTo(ClassDescription o) {
        return this.classTypeName.compareTo(o.classTypeName);
    }

    public Class<?> getSuperType() {
        return this.superType;
    }

    public void setSuperType(Class<?> superType) {
        this.superType = superType;
    }
}

