/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.maven.generator;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.assertj.assertions.generator.AssertionsEntryPointType;

public class AssertionsGeneratorReport {
    private static final String INDENT = "- ";
    private static final String SECTION_START = "--- ";
    private static final String SECTION_END = " ---\n";
    private String directoryPathWhereAssertionFilesAreGenerated = "no directory set";
    private Set<String> generatedCustomAssertionFileNames;
    private Map<AssertionsEntryPointType, File> assertionsEntryPointFilesByType = Maps.newTreeMap();
    private String[] inputPackages;
    private String[] inputClasses;
    private Exception exception;
    private Collection<Class<?>> excludedClassesFromAssertionGeneration;
    private Set<String> inputClassesNotFound;
    private List<String> userTemplates;

    public AssertionsGeneratorReport() {
        this.generatedCustomAssertionFileNames = Sets.newTreeSet();
        this.inputClassesNotFound = Sets.newTreeSet();
        this.userTemplates = new ArrayList<String>();
    }

    public void setDirectoryPathWhereAssertionFilesAreGenerated(String directory) {
        this.directoryPathWhereAssertionFilesAreGenerated = directory;
    }

    public void addGeneratedAssertionFile(File generatedCustomAssertionFile) throws IOException {
        this.generatedCustomAssertionFileNames.add(generatedCustomAssertionFile.getCanonicalPath());
    }

    public String getReportContent() {
        StringBuilder reportBuilder = new StringBuilder(System.lineSeparator());
        reportBuilder.append(System.lineSeparator());
        reportBuilder.append("====================================\n");
        reportBuilder.append("AssertJ assertions generation report\n");
        reportBuilder.append("====================================\n");
        this.buildGeneratorParametersReport(reportBuilder);
        reportBuilder.append(System.lineSeparator());
        reportBuilder.append(SECTION_START).append("Generator results").append(SECTION_END);
        if (this.generationError()) {
            this.buildGeneratorReportError(reportBuilder);
        } else if (this.nothingGenerated()) {
            this.buildGeneratorReportWhenNothingWasGenerated(reportBuilder);
        } else {
            this.buildGeneratorReportSuccess(reportBuilder);
        }
        return reportBuilder.toString();
    }

    private void buildGeneratorReportSuccess(StringBuilder reportBuilder) {
        reportBuilder.append(System.lineSeparator());
        reportBuilder.append("Directory where custom assertions files have been generated:\n");
        reportBuilder.append(INDENT).append(this.directoryPathWhereAssertionFilesAreGenerated).append(System.lineSeparator());
        reportBuilder.append(System.lineSeparator());
        reportBuilder.append("Custom assertions files generated:\n");
        for (String fileName : this.generatedCustomAssertionFileNames) {
            reportBuilder.append(INDENT).append(fileName).append(System.lineSeparator());
        }
        if (!this.inputClassesNotFound.isEmpty()) {
            reportBuilder.append(System.lineSeparator());
            reportBuilder.append("No custom assertions files generated for the following input classes as they were not found:\n");
            for (String inputClassNotFound : this.inputClassesNotFound) {
                reportBuilder.append(INDENT).append(inputClassNotFound).append(System.lineSeparator());
            }
        }
        this.reportEntryPointClassesGeneration(reportBuilder);
    }

    private void reportEntryPointClassesGeneration(StringBuilder reportBuilder) {
        for (AssertionsEntryPointType type : this.assertionsEntryPointFilesByType.keySet()) {
            if (this.assertionsEntryPointFilesByType.get(type) == null) continue;
            String entryPointClassName = StringUtils.remove((String)type.getFileName(), (String)".java");
            reportBuilder.append(System.lineSeparator()).append(entryPointClassName).append(" entry point class has been generated in file:\n").append(INDENT).append(this.assertionsEntryPointFilesByType.get(type).getAbsolutePath()).append(System.lineSeparator());
        }
    }

    private void buildGeneratorReportWhenNothingWasGenerated(StringBuilder reportBuilder) {
        reportBuilder.append(System.lineSeparator());
        reportBuilder.append("No assertions generated as no classes have been found from given classes/packages.\n");
        if (ArrayUtils.isNotEmpty((Object[])this.inputClasses)) {
            reportBuilder.append(INDENT).append("Given classes : ").append(Arrays.toString(this.inputClasses));
            reportBuilder.append(System.lineSeparator());
        }
        if (ArrayUtils.isNotEmpty((Object[])this.inputPackages)) {
            reportBuilder.append(INDENT).append("Given packages : ").append(Arrays.toString(this.inputPackages));
            reportBuilder.append(System.lineSeparator());
        }
        if (CollectionUtils.isNotEmpty(this.excludedClassesFromAssertionGeneration)) {
            reportBuilder.append(INDENT).append("Excluded classes : ").append(this.excludedClassesFromAssertionGeneration);
        }
    }

    private void buildGeneratorReportError(StringBuilder reportBuilder) {
        reportBuilder.append(System.lineSeparator());
        reportBuilder.append("Assertions failed with error : ").append(this.exception.getMessage());
        reportBuilder.append(System.lineSeparator());
        if (ArrayUtils.isNotEmpty((Object[])this.inputClasses)) {
            reportBuilder.append(INDENT).append("Given classes were : ").append(Arrays.toString(this.inputClasses));
            reportBuilder.append(System.lineSeparator());
        }
        if (ArrayUtils.isNotEmpty((Object[])this.inputPackages)) {
            reportBuilder.append(INDENT).append("Given packages were : ").append(Arrays.toString(this.inputPackages));
            reportBuilder.append(System.lineSeparator());
        }
        reportBuilder.append(System.lineSeparator());
        reportBuilder.append("Full error stack : ").append(ExceptionUtils.getStackTrace((Throwable)this.exception));
    }

    private void buildGeneratorParametersReport(StringBuilder reportBuilder) {
        reportBuilder.append(System.lineSeparator());
        reportBuilder.append(SECTION_START).append("Generator input parameters").append(SECTION_END).append(System.lineSeparator());
        if (CollectionUtils.isNotEmpty(this.userTemplates)) {
            reportBuilder.append("The following templates will replace the ones provided by AssertJ when generating AssertJ assertions :\n");
            for (String string : this.userTemplates) {
                reportBuilder.append(INDENT).append(string).append(System.lineSeparator());
            }
            reportBuilder.append(System.lineSeparator());
        }
        if (ArrayUtils.isNotEmpty((Object[])this.inputPackages)) {
            reportBuilder.append("Generating AssertJ assertions for classes in following packages and subpackages:\n");
            for (String inputPackage : this.inputPackages) {
                reportBuilder.append(INDENT).append(inputPackage).append(System.lineSeparator());
            }
        }
        if (ArrayUtils.isNotEmpty((Object[])this.inputClasses)) {
            if (ArrayUtils.isNotEmpty((Object[])this.inputPackages)) {
                reportBuilder.append(System.lineSeparator());
            }
            reportBuilder.append("Generating AssertJ assertions for classes:\n");
            for (String inputClass : this.inputClasses) {
                reportBuilder.append(INDENT).append(inputClass).append(System.lineSeparator());
            }
        }
        if (CollectionUtils.isNotEmpty(this.excludedClassesFromAssertionGeneration)) {
            reportBuilder.append(System.lineSeparator());
            reportBuilder.append("Input classes excluded from assertions generation:\n");
            for (Class clazz : this.excludedClassesFromAssertionGeneration) {
                reportBuilder.append(INDENT).append(clazz.getName()).append(System.lineSeparator());
            }
        }
    }

    private boolean generationError() {
        return this.exception != null;
    }

    private boolean nothingGenerated() {
        return this.generatedCustomAssertionFileNames.isEmpty();
    }

    public void reportEntryPointGeneration(AssertionsEntryPointType assertionsEntryPointType, File assertionsEntryPointFile) {
        this.assertionsEntryPointFilesByType.put(assertionsEntryPointType, assertionsEntryPointFile);
    }

    public void setInputPackages(String[] packages) {
        this.inputPackages = packages;
    }

    public void setInputClasses(String[] classes) {
        this.inputClasses = classes;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public Exception getReportedException() {
        return this.exception;
    }

    public void setExcludedClassesFromAssertionGeneration(Collection<Class<?>> excludedClassSet) {
        this.excludedClassesFromAssertionGeneration = excludedClassSet;
    }

    public Set<String> getInputClassesNotFound() {
        return this.inputClassesNotFound;
    }

    public void reportInputClassesNotFound(Set<Class<?>> classes, String[] inputClassNames) {
        TreeSet classesFound = Sets.newTreeSet();
        for (Class<?> clazz : classes) {
            classesFound.add(clazz.getName());
        }
        for (String inputClass : inputClassNames) {
            if (classesFound.contains(inputClass)) continue;
            this.inputClassesNotFound.add(inputClass);
        }
    }

    public void registerUserTemplate(String userTemplateDescription) {
        this.userTemplates.add(userTemplateDescription);
    }

    public List<String> getUserTemplates() {
        return this.userTemplates;
    }
}

