/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.maven.generator;

import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.maven.plugin.logging.Log;
import org.assertj.assertions.generator.AssertionsEntryPointType;
import org.assertj.assertions.generator.BaseAssertionGenerator;
import org.assertj.assertions.generator.Template;
import org.assertj.assertions.generator.description.ClassDescription;
import org.assertj.assertions.generator.description.converter.ClassToClassDescriptionConverter;
import org.assertj.assertions.generator.util.ClassUtil;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.maven.Templates;
import org.assertj.maven.generator.AssertionsGeneratorReport;

public class AssertionsGenerator {
    private static final Pattern INCLUDE_EVERYTHING = Pattern.compile(".*");
    private ClassToClassDescriptionConverter converter;
    private ClassLoader classLoader;
    private BaseAssertionGenerator generator = new BaseAssertionGenerator();
    private Pattern[] includePatterns;
    private Pattern[] excludePatterns;
    private Log log;
    private Set<AssertionsEntryPointType> assertionsEntryPointToGenerate;

    public AssertionsGenerator(ClassLoader classLoader) throws FileNotFoundException, IOException {
        this.converter = new ClassToClassDescriptionConverter();
        this.classLoader = classLoader;
        this.includePatterns = new Pattern[]{INCLUDE_EVERYTHING};
        this.excludePatterns = new Pattern[0];
        this.assertionsEntryPointToGenerate = org.assertj.core.util.Sets.newHashSet();
    }

    public void setIncludePatterns(String[] includeRegexs) {
        if (Arrays.isNullOrEmpty((Object[])includeRegexs)) {
            this.includePatterns = new Pattern[]{INCLUDE_EVERYTHING};
            return;
        }
        this.includePatterns = new Pattern[includeRegexs.length];
        for (int i = 0; i < includeRegexs.length; ++i) {
            this.includePatterns[i] = Pattern.compile(includeRegexs[i]);
        }
    }

    public void setExcludePatterns(String[] excludeRegexs) {
        if (Arrays.isNullOrEmpty((Object[])excludeRegexs)) {
            return;
        }
        this.excludePatterns = new Pattern[excludeRegexs.length];
        for (int i = 0; i < excludeRegexs.length; ++i) {
            this.excludePatterns[i] = Pattern.compile(excludeRegexs[i]);
        }
    }

    public AssertionsGeneratorReport generateAssertionsFor(String[] inputPackages, String[] inputClassNames, String destDir, String entryPointFilePackage, boolean hierarchical, Templates userTemplates) {
        this.generator.setDirectoryWhereAssertionFilesAreGenerated(destDir);
        AssertionsGeneratorReport report = new AssertionsGeneratorReport();
        report.setDirectoryPathWhereAssertionFilesAreGenerated(destDir);
        this.registerUserTemplates(userTemplates, report);
        HashSet<ClassDescription> classDescriptions = new HashSet<ClassDescription>();
        report.setInputPackages(inputPackages);
        report.setInputClasses(inputClassNames);
        try {
            ClassDescription classDescription;
            Set classes = ClassUtil.collectClasses((ClassLoader)this.classLoader, (String[])((String[])ArrayUtils.addAll((Object[])inputPackages, (Object[])inputClassNames)));
            report.reportInputClassesNotFound(classes, inputClassNames);
            Set<Class<?>> filteredClasses = this.removeAssertClasses(classes);
            this.removeClassesAccordingToIncludeAndExcludePatterns(filteredClasses);
            report.setExcludedClassesFromAssertionGeneration(CollectionUtils.subtract((Collection)classes, filteredClasses));
            if (hierarchical) {
                for (Class<?> clazz : filteredClasses) {
                    classDescription = this.converter.convertToClassDescription(clazz);
                    File[] generatedCustomAssertionFiles = this.generator.generateHierarchicalCustomAssertionFor(classDescription, filteredClasses);
                    report.addGeneratedAssertionFile(generatedCustomAssertionFiles[0]);
                    report.addGeneratedAssertionFile(generatedCustomAssertionFiles[1]);
                    classDescriptions.add(classDescription);
                }
            } else {
                for (Class<?> clazz : filteredClasses) {
                    classDescription = this.converter.convertToClassDescription(clazz);
                    File generatedCustomAssertionFile = this.generator.generateCustomAssertionFor(classDescription);
                    report.addGeneratedAssertionFile(generatedCustomAssertionFile);
                    classDescriptions.add(classDescription);
                }
            }
            for (AssertionsEntryPointType assertionsEntryPointType : this.assertionsEntryPointToGenerate) {
                File assertionsEntryPointFile = this.generator.generateAssertionsEntryPointClassFor(classDescriptions, assertionsEntryPointType, entryPointFilePackage);
                report.reportEntryPointGeneration(assertionsEntryPointType, assertionsEntryPointFile);
            }
        }
        catch (Exception e) {
            report.setException(e);
        }
        return report;
    }

    private void registerUserTemplates(Templates userTemplates, AssertionsGeneratorReport report) {
        if (userTemplates == null) {
            return;
        }
        for (Template template : userTemplates.getTemplates(report)) {
            this.generator.register(template);
        }
    }

    private void removeClassesAccordingToIncludeAndExcludePatterns(Set<Class<?>> filteredClasses) {
        Iterator<Class<?>> it = filteredClasses.iterator();
        while (it.hasNext()) {
            Class<?> element = it.next();
            if (this.isIncluded(element) && !this.isExcluded(element)) continue;
            it.remove();
        }
    }

    private boolean isIncluded(Class<?> element) {
        String className = element.getName();
        for (Pattern includePattern : this.includePatterns) {
            if (!includePattern.matcher(className).matches()) continue;
            return true;
        }
        this.log.debug((CharSequence)("Won't generate assertions for " + className + " as it does not match any include regex."));
        return false;
    }

    private boolean isExcluded(Class<?> element) {
        String className = element.getName();
        for (Pattern excludePattern : this.excludePatterns) {
            if (!excludePattern.matcher(className).matches()) continue;
            this.log.debug((CharSequence)("Won't generate assertions for " + className + " as it matches exclude regex : " + excludePattern));
            return true;
        }
        return false;
    }

    private Set<Class<?>> removeAssertClasses(Set<Class<?>> classList) {
        LinkedHashSet filteredClassList = Sets.newLinkedHashSet();
        for (Class<?> clazz : classList) {
            String classSimpleName = clazz.getSimpleName();
            if (classSimpleName.endsWith("Assert") || classSimpleName.endsWith("Assertions")) continue;
            filteredClassList.add(clazz);
        }
        return filteredClassList;
    }

    @VisibleForTesting
    public void setBaseGenerator(BaseAssertionGenerator generator) {
        this.generator = generator;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void enableEntryPointClassesGenerationFor(AssertionsEntryPointType type) {
        this.assertionsEntryPointToGenerate.add(type);
    }
}

