/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.maven;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.assertj.assertions.generator.AssertionsEntryPointType;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.maven.Templates;
import org.assertj.maven.generator.AssertionsGenerator;
import org.assertj.maven.generator.AssertionsGeneratorReport;

@Mojo(name="generate-assertions", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES, requiresDependencyResolution=ResolutionScope.TEST, requiresProject=true)
public class AssertJAssertionsGeneratorMojo
extends AbstractMojo {
    private static final String[] INCLUDE_ALL_CLASSES = new String[]{".*"};
    @Parameter(property="project", required=true, readonly=true)
    public MavenProject project;
    @Parameter(defaultValue="${project.build.directory}/generated-test-sources/assertj-assertions", property="assertj.targetDir")
    public String targetDir;
    @Parameter(property="assertj.packages")
    public String[] packages;
    @Parameter(property="assertj.classes")
    public String[] classes;
    @Parameter(property="assertj.includes")
    public String[] includes = INCLUDE_ALL_CLASSES;
    @Parameter(property="assertj.excludes")
    public String[] excludes = new String[0];
    @Parameter(defaultValue="false", property="assertj.hierarchical")
    public boolean hierarchical;
    @Parameter(property="assertj.entryPointClassPackage")
    public String entryPointClassPackage;
    @Parameter(property="assertj.skip")
    public boolean skip = false;
    @Parameter(property="assertj.generate.Assertions")
    public boolean generateAssertions = true;
    @Parameter(property="assertj.generate.BddAssertions")
    public boolean generateBddAssertions = true;
    @Parameter(property="assertj.generate.JUnitSoftAssertions")
    public boolean generateJUnitSoftAssertions = true;
    @Parameter(property="assertj.generate.SoftAssertions")
    public boolean generateSoftAssertions = true;
    @Parameter(property="assertj.templates")
    public Templates templates;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Assertions generator is disabled as 'skip' option is true.");
            return;
        }
        this.failIfMojoParametersAreMissing();
        try {
            ClassLoader projectClassLoader = this.getProjectClassLoader();
            AssertionsGenerator assertionGenerator = new AssertionsGenerator(projectClassLoader);
            assertionGenerator.setIncludePatterns(this.includes);
            assertionGenerator.setExcludePatterns(this.excludes);
            if (this.generateAssertions) {
                assertionGenerator.enableEntryPointClassesGenerationFor(AssertionsEntryPointType.STANDARD);
            }
            if (this.generateBddAssertions) {
                assertionGenerator.enableEntryPointClassesGenerationFor(AssertionsEntryPointType.BDD);
            }
            if (this.generateSoftAssertions) {
                assertionGenerator.enableEntryPointClassesGenerationFor(AssertionsEntryPointType.SOFT);
            }
            if (this.generateJUnitSoftAssertions) {
                if (this.junitFoundBy(projectClassLoader)) {
                    assertionGenerator.enableEntryPointClassesGenerationFor(AssertionsEntryPointType.JUNIT_SOFT);
                } else {
                    this.getLog().info((CharSequence)"JUnit not found in project classpath => JUnitSoftAssertions entry point class won't be generated.");
                }
            }
            assertionGenerator.setLog(this.getLog());
            this.executeWithAssertionGenerator(assertionGenerator);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    @VisibleForTesting
    AssertionsGeneratorReport executeWithAssertionGenerator(AssertionsGenerator assertionGenerator) {
        if (this.classes == null) {
            this.classes = new String[0];
        }
        AssertionsGeneratorReport generatorReport = assertionGenerator.generateAssertionsFor(this.packages, this.classes, this.targetDir, this.entryPointClassPackage, this.hierarchical, this.templates);
        this.getLog().info((CharSequence)generatorReport.getReportContent());
        this.project.addTestCompileSourceRoot(this.targetDir);
        return generatorReport;
    }

    private void failIfMojoParametersAreMissing() throws MojoFailureException {
        if (ArrayUtils.isEmpty((Object[])this.packages) && ArrayUtils.isEmpty((Object[])this.classes)) {
            throw new MojoFailureException(AssertJAssertionsGeneratorMojo.shouldHaveNonEmptyPackagesOrClasses());
        }
    }

    private ClassLoader getProjectClassLoader() throws DependencyResolutionRequiredException, MalformedURLException {
        ArrayList classpathElements = new ArrayList(this.project.getCompileClasspathElements());
        classpathElements.addAll(this.project.getTestClasspathElements());
        ArrayList<URL> classpathElementUrls = new ArrayList<URL>(classpathElements.size());
        for (int i = 0; i < classpathElements.size(); ++i) {
            classpathElementUrls.add(new File((String)classpathElements.get(i)).toURI().toURL());
        }
        return new URLClassLoader(classpathElementUrls.toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
    }

    @VisibleForTesting
    static String shouldHaveNonEmptyPackagesOrClasses() {
        return String.format("Parameter 'packages' or 'classes' must be set to generate assertions.%n[Help] https://github.com/joel-costigliola/assertj-assertions-generator-maven-plugin", new Object[0]);
    }

    private boolean junitFoundBy(ClassLoader projectClassLoader) {
        try {
            Class.forName("org.junit.Rule", false, projectClassLoader);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

